const express = require('express');
const router = express.Router();
const db = require('../db');

// GET /api/students
router.get('/', async (req, res) => {
  try {
    const rows = await db.listStudents();
    res.json(rows);
  } catch (err) { res.status(500).json({ error: err.message }); }
});

// POST /api/students
router.post('/', async (req, res) => {
  try {
    const { name, class: cls, parent_name } = req.body;
    if (!name) return res.status(400).json({ error: 'name is required' });
    const id = await db.createStudent(name, cls || '', parent_name || '');
    res.json({ id });
  } catch (err) { res.status(500).json({ error: err.message }); }
});

// GET /api/students/:id
router.get('/:id', async (req, res) => {
  try {
    const s = await db.getStudent(req.params.id);
    if (!s) return res.status(404).json({ error: 'Not found' });
    res.json(s);
  } catch (err) { res.status(500).json({ error: err.message }); }
});

// PUT /api/students/:id
router.put('/:id', async (req, res) => {
  try {
    const { name, class: cls, parent_name } = req.body;
    const updated = await db.updateStudent(req.params.id, name, cls, parent_name);
    res.json(updated);
  } catch (err) { res.status(500).json({ error: err.message }); }
});

// DELETE /api/students/:id
router.delete('/:id', async (req, res) => {
  try {
    await db.deleteStudent(req.params.id);
    res.json({ ok: true });
  } catch (err) { res.status(500).json({ error: err.message }); }
});

module.exports = router;