const express = require('express');
const path = require('path');
const dotenv = require('dotenv');
const cors = require('cors');

dotenv.config();

const app = express();
const PORT = process.env.PORT || 3000;

const db = require('./db');

// Middleware
app.use(cors());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(express.static(path.join(__dirname, 'public')));

// Routes
app.use('/api/students', require('./routes/students'));
app.use('/api/fees', require('./routes/fees'));
app.use('/api/payments', require('./routes/payments'));

// Simple health
app.get('/api/health', (req, res) => res.json({ ok: true, app: process.env.APP_NAME || 'Syahriah' }));

// Export payments CSV
app.get('/api/export/payments.csv', async (req, res) => {
  try {
    const rows = await db.allPayments();
    res.setHeader('Content-Type', 'text/csv');
    res.setHeader('Content-Disposition', 'attachment; filename="payments.csv"');
    const header = 'payment_id,student_id,student_name,fee_id,month,year,amount,paid_at\n';
    const body = rows.map(r => `${r.id},${r.student_id},"${r.name}",${r.fee_id},${r.month},${r.year},${r.amount},${r.paid_at}`).join('\n');
    res.send(header + body);
  } catch (err) {
    console.error(err);
    res.status(500).send('Export failed');
  }
});

app.listen(PORT, () => {
  console.log(`${process.env.APP_NAME || 'Syahriah'} running on http://localhost:${PORT}`);
});